/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.core.ModVillagers;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.MyrmexAIAttackPlayers;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIEscortEntity;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIFindGaurdingEntity;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILeaveHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIMoveThroughHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIReEnterHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIWander;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class EntityMyrmexSoldier
extends EntityMyrmexBase {
    private static final ResourceLocation TEXTURE_DESERT = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_soldier.png");
    private static final ResourceLocation TEXTURE_JUNGLE = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_soldier.png");
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_STING = Animation.create((int)15);
    public EntityMyrmexBase guardingEntity = null;
    public static final ResourceLocation DESERT_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "myrmex_soldier_desert"));
    public static final ResourceLocation JUNGLE_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "myrmex_soldier_jungle"));

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    public EntityMyrmexSoldier(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.99f, 0.95f);
    }

    public void func_70636_d() {
        double dist;
        super.func_70636_d();
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.getAnimationTick() == 6) {
            this.playBiteSound();
            dist = this.func_70068_e((Entity)this.func_70638_az());
            if (dist < 4.0) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            }
        }
        if (this.getAnimation() == ANIMATION_STING && this.getAnimationTick() == 0) {
            this.playStingSound();
        }
        if (this.getAnimation() == ANIMATION_STING && this.func_70638_az() != null && this.getAnimationTick() == 6 && (dist = this.func_70068_e((Entity)this.func_70638_az())) < 4.0) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 2));
            this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 2));
        }
        if (this.guardingEntity != null) {
            this.guardingEntity.isBeingGuarded = true;
            this.isEnteringHive = this.guardingEntity.isEnteringHive;
            if (!this.guardingEntity.func_70089_S()) {
                this.guardingEntity.isBeingGuarded = false;
                this.guardingEntity = null;
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new MyrmexAITradePlayer(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new MyrmexAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new MyrmexAIEscortEntity(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new MyrmexAIReEnterHive(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new MyrmexAILeaveHive(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new MyrmexAIMoveThroughHive(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new MyrmexAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new MyrmexAIDefendHive(this));
        this.field_70715_bh.func_75776_a(2, new MyrmexAIFindGaurdingEntity(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new MyrmexAIAttackPlayers(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, true, (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(@Nullable EntityLiving entity) {
                return entity != null && !IMob.field_175450_e.apply((Object)entity) && !EntityMyrmexBase.haveSameHive(EntityMyrmexSoldier.this, (Entity)entity) && DragonUtils.isAlive((EntityLivingBase)entity);
            }
        }));
    }

    @Override
    public VillagerRegistry.VillagerProfession getProfessionForge() {
        return this.isJungle() ? ModVillagers.INSTANCE.jungleMyrmexSoldier : ModVillagers.INSTANCE.desertMyrmexSoldier;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(6.0);
    }

    @Override
    public ResourceLocation getAdultTexture() {
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 0.8f;
    }

    @Override
    public int getCasteImportance() {
        return 1;
    }

    @Override
    public boolean shouldLeaveHive() {
        return false;
    }

    @Override
    public boolean shouldEnterHive() {
        return this.guardingEntity == null || !this.guardingEntity.canSeeSky() || this.guardingEntity.shouldEnterHive();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING) {
            if (this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_STING : ANIMATION_BITE);
                if (!this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(3) == 0 && this.func_184586_b(EnumHand.MAIN_HAND) != ItemStack.field_190927_a) {
                    this.func_70099_a(this.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
                    this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                }
                if (!this.func_184188_bt().isEmpty()) {
                    for (Entity entity : this.func_184188_bt()) {
                        entity.func_184210_p();
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean needsGaurding() {
        return false;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_BITE, ANIMATION_STING};
    }
}

